// Steuert die Anzeige der Konsole
const output = document.getElementById('output');
window.api.onConsoleOutput((text) => {
  output.textContent += text;
  output.scrollTop = output.scrollHeight;
});

// Zeigt die Version unten rechts
window.addEventListener('DOMContentLoaded', async () => {
  const versionEl = document.getElementById('version');
  if (versionEl && window.api?.getVersion) {
    const version = await window.api.getVersion();
    versionEl.textContent = `Version ${version}`;
  }

  aktualisiereUhrzeit(); // sofort anzeigen
  setInterval(aktualisiereUhrzeit, 60000); // jede Minute neu
});

// Zeigt Datum und Uhrzeit oben links (ohne Sekunden)
function aktualisiereUhrzeit() {
  const uhr = document.getElementById('uhrzeit');
  if (!uhr) return;

  const jetzt = new Date();
  const datum = jetzt.toLocaleDateString('de-DE');
  const stunde = jetzt.getHours().toString().padStart(2, '0');
  const minute = jetzt.getMinutes().toString().padStart(2, '0');
  uhr.textContent = `${datum} – ${stunde}:${minute}`;
}
