const { contextBridge, ipcRenderer } = require('electron');

contextBridge.exposeInMainWorld('api', {
  startReset: () => ipcRenderer.send('start-reset'),
  stopReset: () => ipcRenderer.send('stop-reset'),
  startWlanTest: () => ipcRenderer.send('start-wlantest'),
  startMacTest: () => ipcRenderer.send('start-mactest'),
  onConsoleOutput: (callback) => ipcRenderer.on('console-output', (_, msg) => callback(msg)),
  getVersion: async () => await ipcRenderer.invoke('get-app-version')
});
