// Hauptprozess: Fenster erstellen und Buttons steuern
const { app, BrowserWindow, ipcMain } = require('electron');
const path = require('path');
const { spawn } = require('child_process');

let child = null;       // reset.js
let wlanChild = null;   // wlanTest.js
let macChild = null;

function createWindow() {
  const win = new BrowserWindow({
    width: 1000,
    height: 800,
    webPreferences: {
      preload: path.join(__dirname, 'preload.js')
    }
  });

  win.loadFile('index.html');
}

app.whenReady().then(createWindow);

app.setLoginItemSettings({
  openAtLogin: true,
  path: app.getPath('exe')
});

// Versions-Request vom Renderer
ipcMain.handle('get-app-version', () => {
  return app.getVersion();
});

// Start reset.js
ipcMain.on('start-reset', (event) => {
  if (child === null) {
    const resetPath = path.join(__dirname, 'reset.js');
    child = spawn('node', [resetPath]);

    child.stdout.on('data', (data) => {
      event.reply('console-output', data.toString());
    });

    child.stderr.on('data', (data) => {
      event.reply('console-output', '[Fehler] ' + data.toString());
    });

    child.on('close', (code) => {
      event.reply('console-output', '\n[reset.js wurde beendet mit Code ' + code + ']\n');
      child = null;
    });
  } else {
    event.reply('console-output', '[reset.js läuft bereits]\n');
  }
});

// Start wlanTest.js
ipcMain.on('start-wlantest', (event) => {
  if (wlanChild === null) {
    const wlanPath = path.join(__dirname, 'wlanTest.js');
    wlanChild = spawn('node', [wlanPath]);

    wlanChild.stdout.on('data', (data) => {
      event.reply('console-output', data.toString());
    });

    wlanChild.stderr.on('data', (data) => {
      event.reply('console-output', '[WLAN-Fehler] ' + data.toString());
    });

    wlanChild.on('close', (code) => {
      event.reply('console-output', '[wlanTest.js beendet mit Code ' + code + ']\n');
      wlanChild = null;
    });
  } else {
    event.reply('console-output', '[wlanTest.js läuft bereits]\n');
  }
});

// Start macTest.js
ipcMain.on('start-mactest', (event) => {
  if (macChild === null) {
    const macPath = path.join(__dirname, 'macTest.js');
    macChild = spawn('node', [macPath]);

    macChild.stdout.on('data', (data) => {
      event.reply('console-output', data.toString());
    });

    macChild.stderr.on('data', (data) => {
      event.reply('console-output', '[MAC-Fehler] ' + data.toString());
    });

    macChild.on('close', (code) => {
      event.reply('console-output', '[macTest.js beendet mit Code ' + code + ']\n');
      macChild = null;
    });
  } else {
    event.reply('console-output', '[macTest.js läuft bereits]\n');
  }
});

// Stoppt beide Prozesse bei Klick auf "Kill Reset"
ipcMain.on('stop-reset', (event) => {
  let wasKilled = false;

  if (child) {
    child.kill();
    event.reply('console-output', '[reset.js wurde gestoppt]\n');
    child = null;
    wasKilled = true;
  }

  if (wlanChild) {
    wlanChild.kill();
    event.reply('console-output', '[wlanTest.js wurde gestoppt]\n');
    wlanChild = null;
    wasKilled = true;
  }

  if (!wasKilled) {
    event.reply('console-output', '[Es läuft kein Script]\n');
  }

  if (macChild) {
  macChild.kill();
  event.reply('console-output', '[macTest.js wurde gestoppt]\n');
  macChild = null;
  wasKilled = true;
}
});
